<?php

namespace Sartoric\ModularCms\Controllers\Layouts;

use App\Setting;
use Sartoric\ModularCms\Models\Menuitem;
use Sartoric\ModularCms\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;

class MenuitemController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $menuitems = Menuitem::all();
        $parentmenu = $this->parentmenu();
        return view('sartoric/modularcms::layouts.menuitem.index', compact(['menuitems','parentmenu']));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $menuitem = new Menuitem();
        $parentmenu = $this->parentmenu();
        return view('sartoric/modularcms::layouts.menuitem.create', compact(['menuitem','parentmenu']));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validator($request->all())->validate();
        $appadmin = Setting::appSetting('app-admin');

        if (!empty($appadmin) && substr(request('link'), 0, strlen($appadmin)) === $appadmin) {
            $link = substr(request('link'), strlen($appadmin)+1);
        } else {
            $link = request('link');
        }

        $menuitem = Menuitem::create([
            'name'       => request('name'),
            'label'      => request('label'),
            'link'       => $link,
            'position'   => request('position'),
            'parent'     => request('parent'),
            'active'     => request('active'),
            //'active_flg' => request('active_flg'),
            'menu'       => request('menu'),
            'ico'        => request('ico'),
            'separator'  => request('separator'),
        ]);

        $parentmenu = $this->parentmenu();
        return view('sartoric/modularcms::layouts.menuitem.edit', compact(['menuitem','parentmenu']));
    }

    /**
     * Display the specified resource.
     *
     * @param Menuitem $menuitem
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function show(Menuitem $menuitem)
    {
        $parentmenu = $this->parentmenu();
        return view('sartoric/modularcms::layouts.menuitem.edit', compact(['menuitem','parentmenu']));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Menuitem $menuitem
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function edit(Menuitem $menuitem)
    {
        $parentmenu = $this->parentmenu();
        return view('sartoric/modularcms::layouts.menuitem.edit', compact(['menuitem','parentmenu']));
    }


    public function update(Request $request, Menuitem $menuitem)
    {
        $this->validator($request->all())->validate();
        $appadmin = Setting::appSetting('app-admin');

        if (!empty($appadmin) && substr(request('link'), 0, strlen($appadmin)) === $appadmin) {
            $link = substr(request('link'), strlen($appadmin)+1);
        } else {
            $link = request('link');
        }

        $menuitem->fill([
            'name'       => request('name'),
            'label'      => request('label'),
            'link'       => $link,
            'position'   => request('position'),
            'parent'     => request('parent'),
            'active'     => request('active'),
            //'active_flg' => request('active_flg'),
            'menu'       => request('menu'),
            'ico'        => request('ico'),
            'separator'  => request('separator'),
        ]);

        $menuitem->save();

        $parentmenu = $this->parentmenu();
        return view('sartoric/modularcms::layouts.menuitem.edit', compact(['menuitem','parentmenu']));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Menuitem $menuitem
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function destroy(Menuitem $menuitem)
    {
        if (!auth()->user()->can('delete', $menuitem)) {
            abort(401);
        }
// TODO : Gestire detach
        try {
            $menuitem->delete();
        } catch (\Exception $err) {
            return back()->with('notify', $this->notifArray('DB', 'error', $err->getMessage(), true));
        }
        return redirect()->route('menuitem.index', $menuitem)
            ->with('notify', $this->notifArray('DB', 'success', __('Menu eliminato con successo')));
    }
    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */

    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name'       => 'required|string|max:255',
            'label'      => 'required|string|max:255',
            'link'       => 'nullable|string|max:255',
            'position'   => 'required|integer',
            'parent'     => 'required|integer',
            'active'     => 'required|boolean',
            'active_flg' => 'nullable|string',
            'menu'       => 'required|boolean',
            'ico'        => 'nullable|string|max:255',
            'separator'  => 'required|boolean',
        ]);
    }

    protected function parentmenu($menuitemid = 0)
    {
        return Menuitem::where('id', '<>', $menuitemid)
            ->where('separator', 0)
            ->where('active', 1)
            ->where(function ($query) {
                $query->whereNull('link')
                    ->orWhere('link', '');
            })->get();
    }


}
