<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRolesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sys_roles', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->unique();
            $table->string('description')->nullable();
        });

        Schema::create('sys_menuitem_role', function (Blueprint $table) {
            $table->integer('role_id');
            $table->integer('menuitem_id');

            $table->primary(['role_id','menuitem_id']);
        });

        Schema::create('sys_role_user', function (Blueprint $table) {
            $table->integer('role_id');
            $table->integer('user_id');

            $table->primary(['role_id','user_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sys_roles');

        Schema::dropIfExists('sys_menuitem_role');

        Schema::dropIfExists('sys_role_user');
    }
}
