<?php

namespace Sartoric\ModularCms\Helpers;

use Sartoric\ModularCms\Models\Setting;

class Helper {

    public const VENDORPATH = 'vendor/sartoric/modular-cms/';

    /**
     * @param $path
     * @return string
     */
    static function mcmsAsset($path)
    {
        return asset(self::VENDORPATH.$path);
    }

    static function logoBig()
    {
        $logopath = Setting::appSetting('logobig');
        if (!empty($logopath)) {
            return $logopath;
        } else {
            return self::mcmsAsset('assets/pages/images/logobig.png');
        }
    }
}
