<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/login', 'Auth\LoginController@showLoginForm')->name('login');

// il campo link nella tabella deve essere = route name
Auth::routes();
Route::get('/home', 'Layouts\HomeController@index')->name('home');
// DASHBOARD CHART DATA
Route::get('/dashboard_chart_data', 'Layouts\HomeController@dashchart')->name('dashchart');

Route::middleware(['auth:mcmsweb', 'lock', 'view.rights'])->group(function(){
    Route::get('/profile', function () {
        return view('modularcms::layouts.profile');
    })->name('profile');
});

// Registration Routes...
Route::get('register', 'Auth\RegisterController@showRegistrationForm')->name('register');
Route::post('register', 'Auth\RegisterController@register');
// Social Login
Route::get('/sociallogin/{provider?}', 'Auth\SocialloginController@getSocialAuth')->name('social.login');
Route::get('/sociallogin/callback/{provider?}', 'Auth\SocialloginController@getSocialAuthCallback')->name('social.login.callback');
// Password Reset Routes...
Route::get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('password.request');
Route::post('password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('password.email');
Route::get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
Route::post('password/reset', 'Auth\ResetPasswordController@reset');
// Lock view
Route::get('/lock', 'Auth\LockAccountController@lockscreen')->name('lock');
Route::post('/lock', 'Auth\LockAccountController@unlock')->name('lock.post');
// Change password view
Route::get('/changepassword/{user}/edit', 'Layouts\UserController@showChangePassword')->name('change-password');
Route::put('/changepassword/{user}', 'Layouts\UserController@updateChangePassword');
// App settings view
Route::resource('settings', 'Layouts\SettingController');
Route::post('/settings/updateAll', 'Layouts\SettingController@updateAll');
// Menu item association
Route::resource('menuitem', 'Layouts\MenuitemController');
// App Users view
Route::resource('users', 'Layouts\UserController');
Route::get('/users/{user}/toggleActive', 'Layouts\UserController@toggleActive');
// Users roles view
Route::resource('roles', 'Layouts\RoleController');
// Role permissions view
Route::resource('permissions', 'Layouts\PermissionController');



