<?php

namespace Sartoric\ModularCms\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    protected const ACTION_NAMESPACE = 'Sartoric\ModularCms\Controllers\\';

    public function __construct()
    {
        $this->middleware(['auth', 'lock', 'view.rights']);
    }

    public function notifArray($module, $type, $message, $title = false)
    {
        // TODO: Aggiungere push per avere uno stack di notifiche
        $notifications[] = ['module'=>__($module), 'type'=>$type, 'message'=>__($message), 'title'=>__($title) ];
        return $notifications;
    }

    public function executeAction($action, $parameters = [])
    {
        // Replace all the leading backslash
        $action = preg_replace('/^(\\\\)+/', '', $action);
        $actionNs = Setting::appSetting('action-namespace')?:self::ACTION_NAMESPACE;
        return App::call($actionNs.$action, $parameters);
    }
}
