@extends('sartoric/modularcms::auth.main')

@section('css-page')
    <link href="{{ McmsHelper::mcmsAsset('assets/pages/css/login.min.css')}}" rel="stylesheet" type="text/css" />
@endsection

@section('content')
<div class="content">
    <form class="forget-form" action="{{ route('password.email') }}" method="post" novalidate="novalidate" style="display: block;">
    <h4 class="form-title font-green">Reset Password</h4>
    <p> {{ __('Inserisci il tuo indirizzo email per resettare la password') }} </p>
    {{ csrf_field() }}

    <div class="">
        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
            <label for="email" class="control-label visible-ie8 visible-ie9">{{ __('Indirizzo Email') }}</label>
            <input id="email" type="email" class="form-control form-control-solid placeholder-no-fix"  value="{{ old('email') }}" autocomplete="off" placeholder="Email" name="email" required autofocus>
            @if ($errors->has('email'))
                <span class="help-block">
                    <strong>{{ $errors->first('email') }}</strong>
                </span>
            @endif
        </div>

    </div>
    <div class="form-actions">
        <a href="{{ route('login') }}" type="button" id="-register-back-btn" class="btn grey-salsa btn-outline">{{ __('Indietro') }}</a>
        <button type="submit" class="btn green pull-right"> {{ __('Invia') }} </button>
    </div>
    </form>
</div>
@endsection

