@extends('sartoric/modularcms::layouts.main')
@include('sartoric/modularcms::layouts.partials.body-tag')

@section('css-page')
    <link href="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-table/bootstrap-table.min.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('content')
    <!-- BEGIN TABLE PORTLET-->
    <div class="portlet light bordered ">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-cogs"></i>{{ __('Lista Permessi') }}
            </div>
            <div class="actions">
                @can('create', \Sartoric\ModularCms\Models\Permission::class )
                <a href="{{ action('\Sartoric\ModularCms\Controllers\Layouts\PermissionController@create') }}" class="btn btn-outline btn-circle btn-sm {{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}">
                    <i class="fa fa-plus"></i> {{ __('Aggiungi') }}
                </a>
                @endcan
            </div>
        </div>
        <div class="portlet-body flip-scroll">
            <table data-toggle="table" class="table table-light table-bordered table-striped table-condensed flip-content">
                <thead class="flip-content">
                <tr class="uppercase">
                    <th class="text-center" data-sortable="true"> {{ __('Permesso') }} </th>
                    <th class="text-center" data-sortable="true"> {{ __('Descrizione') }} </th>
                    <th class="text-center"> {{ __('Azioni') }} </th>
                </tr>
                </thead>
                <tbody>
                @foreach($permissions as $permission)
                    <tr>
                        <td class="text-center"> {{ $permission->name }}&nbsp; </td>
                        <td class="text-center"> {{ $permission->description }}&nbsp; </td>
                        <td class="text-center">
                            @include('sartoric/modularcms::layouts.partials.actbtnset', ['buttonmode'=>false,
                                                           'formaction'=>'\Sartoric\ModularCms\Controllers\Layouts\PermissionController',
                                                           'entity'=>$permission,
                                                           'idfield'=>$permission->id,
                                                           'entlabel'=>__('il permesso'),
                                                           'entvalue'=>$permission->name,
                                                           'activeToggle'=>false
                                                           ])
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <!--END TABLE PORTLET-->
@endsection

@section('plugin-page')
    <script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-table/bootstrap-table.min.js') }}" type="text/javascript"></script>
    <script src="{{ McmsHelper::mcmsAsset('assets/js/anchor-delete.js') }}" type="text/javascript"></script>
@endsection

@section('script-page')
    <script src="{{ McmsHelper::mcmsAsset('assets/layouts/layout/scripts/table-bootstrap.min.js') }}" type="text/javascript"></script>
@endsection
