<script>
@if(Session::has('notify'))
    @if(!Sartoric\ModularCms\Models\Setting::appsetting('notifandorid'))
        title = '';
        @if(array_key_exists('title', Session::get('notify'))?Session::get('notify')['title']:false)
            @if(Session::get('notify')['type'] == 'error')
                title  = '<div class="title"><strong>{{  (Session::get('notify')['module']) }}'+' '+'{{ __('Errore') }} </strong></div>';
            @endif

            @if(Session::get('notify')['type'] == 'success')
                title  = '<div class="title"><strong>{{  (Session::get('notify')['module']) }}'+' '+'{{ __('Completato') }} </strong></div>';
            @endif

            @if(Session::get('notify')['type'] == 'info')
                title  = '<div class="title"><strong>{{  (Session::get('notify')['module']) }}'+' '+'{{ __('Info') }} </strong></div>';
            @endif
        @endif
        var dialog = bootbox.alert({
            message:title + '<div class="message">{!! Session::get('notify')['message'] !!}</div>',
            closeButton:false,
            size:'small',
            className:'bootbox-md',
            buttons: {
                ok: {
                    label: '{{ __('Chiudi') }}',
                    className: 'btn btn-no-border btn-outline btn-flat {{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}'
                }
            }
        });
        @if(Session::get('notify')['type'] != 'error')
            setTimeout(function(){ dialog.modal('hide')}, 3000);
        @endif
    @else
        // Android MD style
        const alertdiv = "<div class='md-error col-md-12'  style='display:none'><div class='md-error-message col-xs-9 col-md-6 text-left'>{{ Session::get('notify')['message'] }}</div><div class='col-xs-2 col-xs-offset-1 col-md-offset-4 md-error-confirm text-right' style='cursor:pointer;' onclick='$(\".md-error\").stop().fadeOut(400)'>{{ __('CHIUDI') }}</div></div>";
        $('body').append(alertdiv);
        @if(Session::get('notify')['type'] != 'error')
            $('.md-error').stop().fadeIn(400).delay(3000).fadeOut(400); //fade out after 3 seconds
        @else
            $('.md-error').stop().fadeIn(400);
        @endif
    @endif
@endif

function bbConfirmOnSubmit(event)
{
    var button = $(event.target).find('button[type=submit]');
    var message = button.attr('data-submit-confirm-text');
    var btntext = button.attr('data-submit-confirm-button');

    event.preventDefault();

    bootbox.confirm({
        message:'<div class="message">' + message + '</div>',
        closeButton:false,
        size:'small',
        className:'bootbox-md',
        buttons: {
            confirm: {
                label: btntext,
                className: 'btn-no-border btn-outline btn-flat {{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}'
            },
            cancel: {
                label: '{{ __("Annulla") }}',
                className: 'btn-no-border btn-outline btn-flat {{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}'
            }
        },
        callback: function (result) {
            if(result){
                event.target.submit();
            }
        }
    });
}
</script>