<?php

namespace Sartoric\ModularCms\Controllers\Layouts;

use Illuminate\Http\Request;
use Sartoric\ModularCms\Controllers\Controller;
use Sartoric\ModularCms\Models\Setting;
use Validator;
use Illuminate\Validation\Rule;

class SettingController extends Controller
{
    // TODO : Creare function per salvare i dati dalla view index
    // Viene passato l'array con key->value , andrà trovato il campo setting = key
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $settings=Setting::appsettings();

        return view('sartoric/modularcms::layouts.settings.edit', compact('settings'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('sartoric/modularcms::layouts.settings.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $userid = 0;

        $attributeNames = [
            'setting' => __('Impostazione'),
            'value' => __('Valore'),
            'label' => __('Etichetta'),
            'help' => __('Help text'),
        ];

        Validator::make($request->all(), [
            'value'    => 'required|string|max:255',
            'label'    => 'required|string|max:255',
            'help'     => 'required|string|max:255',
            'setting'  => Rule::unique('sys_settings')->where(function ($query) use ($userid) {
                            $query->where('user_id', $userid);
            })
        ])->setAttributeNames($attributeNames)->validate();

        try {
            $active = request('active')=='on'?true:false;

            Setting::create([
                'setting'  => request('setting'),
                'value'    => request('value'),
                'label'    => request('label'),
                'help'     => request('help'),
                'user_id'  => '0',
//                'active'   => $active
            ]);
        } catch (\Exception $err) {
            return back()->with('notify', $this->notifArray('DB', 'error', $err->getMessage(), true));
        }

        return redirect()->route('settings.index', null)
            ->with('notify', $this->notifArray('DB', 'success', __('Impostazione creata con successo')));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $settings=Setting::appsettings();
        return view('sartoric/modularcms::layouts.settings.edit', compact('settings'));
    }

    /**
     * Update all settings values.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function updateAll(Request $request)
    {
        $request_values = $request->except('_token');

        try{
            foreach ($request_values as $key => $value) {
                if (isset($value)) {
                    $setting = Setting::where('setting', $key)->where('user_id', 0)->first();

                    $setting->fill([
                        'value' => $value
                    ]);

                    $setting->save();
                }
            }
        } catch (\Exception $err) {
            dd('err');
        }

        return redirect()->route('settings.index', null)
            ->with('notify', $this->notifArray('DB', 'success', __('Impostazioni aggiornate con successo')));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */

    protected function validator(array $data)
    {
//        return Validator::make($data, [
//            'fullname'  => 'required|string|max:255',
//            'username'  => 'required|string|max:255|unique:users',
//            'email'     => 'required|string|email|max:255|unique:users',
//            'password'  => 'required|string|min:6|confirmed',
//            'tnc'       => 'accepted'
//        ]);
    }
}
