<?php

namespace Sartoric\ModularCms\Providers;

use Sartoric\ModularCms\Helpers\Helper;
use Sartoric\ModularCms\Middleware\LockAccount;
use Sartoric\ModularCms\Middleware\ViewRights;

use Illuminate\Support\ServiceProvider;

class McmsServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
//  PUBLISH
//        Config
        $this->publishes([
            __DIR__.'/../Config/modularcms.php' => config_path('modularcms.php'),
        ]);
//        Views
        $this->publishes([
            __DIR__.'/../Views' => resource_path('views/vendor/sartoric/modularcms'),
        ], 'developer');
//        Controllers
        $this->publishes([
            __DIR__.'/../Controllers' => app_path('Http/Controllers'),
        ], 'developer');
//        Models
        $this->publishes([
            __DIR__.'/../Models' => app_path('Http/Controllers'),
        ], 'developer');
//        Migrations
        $this->publishes([
            __DIR__.'/../Migrations' => database_path('migrations')
        ], 'migrations');
//        Assets
        $this->publishes([
            __DIR__.'/../assets' => public_path(Helper::VENDORPATH.'/assets/'),
        ], 'public');
//        Translations
        $this->publishes([
            __DIR__.'/../translations' => resource_path('lang/vendor/sartoric/modularcms'),
        ], 'public');

//  LOADER
//        Views
        $this->loadViewsFrom(__DIR__.'/../Views', 'sartoric/modularcms');
//        Routes
        $this->loadRoutesFrom(__DIR__.'/../Routes/web.php');
//        Migrations
        $this->loadMigrationsFrom(__DIR__.'/../Migrations');
//        Translations
        $this->loadTranslationsFrom(__DIR__.'/../Translations', 'sartoric/modularcms');

//       Config
        // TODO override auth.php provider / user / model
        //$this->app['config']['auth'] =  \Config::get('::auth');

//      Package middleware
        $this->app['router']->aliasMiddleware('lock' , LockAccount::class);
        $this->app['router']->aliasMiddleware('view.rights', ViewRights::class);

        //Share menu items with main view
        view()->composer(['sartoric/modularcms::layouts.main'],'Sartoric\ModularCms\ViewComposers\MenuComposer');
        // load package helpers
        $this->loadHelpers();
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        // ...
    }

    protected function loadHelpers()
    {
        if (file_exists($file = __DIR__ . '/../Helpers/Helper.php')) {
            require_once $file;
        }
    }
}
