@extends('sartoric/modularcms::layouts.main')

@include('sartoric/modularcms::layouts.partials.body-tag-solid')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN SAMPLE FORM PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-{{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}">
                        <i class="icon-pencil font-{{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}"></i>
                        <span class="caption-subject bold uppercase"> {{ __('Modifica Password') }}</span>
                    </div>
                </div>
                <div class="portlet-body form">
                    <form role="form" class="login-form form-horizontal" method="post" action="{{ action('\Sartoric\ModularCms\Controllers\Layouts\UserController@updateChangePassword', ['user'=>$user->id]) }}">
                        {{ csrf_field() }}
                        {{ method_field('PUT') }}

                        <div class="form-body">

                            <div class="form-group form-md-line-input {{ $errors->has('old_password')?' has-error ':'' }}">
                                <label class="col-md-2 control-label" for="old_password">{{ __('Vecchia Password') }}</label>
                                <div class="col-md-9">
                                    <input type="password" class="form-control" id="old_password" name="old_password">
                                    <div class="form-control-focus"> </div>
                                    <span class="help-block">{{ __('Inserire la vecchia password') }}</span>
                                </div>
                            </div>

                            <div class="form-group form-md-line-input {{ $errors->has('new_password')?' has-error ':'' }}">
                                <label class="col-md-2 control-label" for="new_password">{{ __('Nuova Password') }}</label>
                                <div class="col-md-9">
                                    <input type="password" class="form-control pwd-strength" id="new_password" name="new_password">
                                    <div class="form-control-focus"> </div>
                                    <span class="help-block">{{ __('Inserire la nuova password') }}</span>
                                </div>
                            </div>

                            <div class="form-group form-md-line-input {{ $errors->has('new_password_confirmation')?' has-error ':'' }}">
                                <label class="col-md-2 control-label" for="new_password_confirmation">{{ __('Reinserire la nuova Password') }}</label>
                                <div class="col-md-9">
                                    <input type="password" class="form-control" id="new_password_confirmation" name="new_password_confirmation">
                                    <div class="form-control-focus"> </div>
                                    <span class="help-block">{{ __('Inserire la nuova password') }}</span>
                                </div>
                            </div>


                        </div>

                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-2 col-md-10">
                                    <button type="submit" class="btn {{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}">{{ __('Modifica') }}</button>
                                </div>
                            </div>
                        </div>

                    </form>
                    @include('sartoric/modularcms::layouts.partials.errors')
                </div>
            </div>
            <!-- END SAMPLE FORM PORTLET-->
        </div>
    </div>
@endsection

@section('plugin-page')
    <script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-pwstrength/pwstrength-bootstrap.min.js') }}" type="text/javascript"></script>
@endsection

@section('script-page')
    {{--<script>--}}
    {{--// Variable for password check messages--}}
    {{--var pwdstrarray= {--}}
    {{--weak:"{{ __('Debole') }}",--}}
    {{--normal:"{{ __('Normale') }}",--}}
    {{--medium:"{{ __('Media') }}",--}}
    {{--strong:"{{ __('Sicura') }}",--}}
    {{--vstrong:"{{ __('Molto sicura') }}",--}}
    {{--};--}}
    {{--</script>--}}
    <script src="{{ McmsHelper::mcmsAsset('assets/js/custom-pwdstrength.js') }}" type="text/javascript"></script>
@endsection
