<?php

namespace Sartoric\ModularCms\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function __construct()
    {
        $this->middleware(['auth', 'lock', 'view.rights']);
    }

    public function notifArray($module, $type, $message, $title = false)
    {
        $notifications[] = ['module'=>__($module), 'type'=>$type, 'message'=>__($message), 'title'=>__($title) ];
        return $notifications;
    }
}
