<?php

namespace Sartoric\ModularCms\Controllers\Layouts;

use Sartoric\ModularCms\Models\Permission;
use Illuminate\Http\Request;
use Sartoric\ModularCms\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class PermissionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $permissions = Permission::appPermissions();
        return view('sartoric/modularcms::layouts.permissions.index', compact('permissions'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $permission = new Permission();
        return view('sartoric/modularcms::layouts.permissions.create', compact(['permission']));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validator($request->all())->validate();

        $permission = Permission::create([
            'name' => request('name'),
            'description' => request('description'),
        ]);

        if (!$request->user()->can('create', $permission)) {
            abort(401);
        }

        try {

            $permission->save();

        } catch (\Exception $err) {
            return back()->with('notify',$this->notifArray('DB', 'error', $err->getMessage(), true));
        }
        return redirect()->route('permissions.edit', $permission)
            ->with('notify', $this->notifArray('DB', 'success', __('Permesso creato con successo')));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Permission  $permission
     * @return \Illuminate\Http\Response
     */
    public function show(Permission $permission)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Permission  $permission
     * @return \Illuminate\Http\Response
     */
    public function edit(Permission $permission)
    {
        return view('sartoric/modularcms::layouts.permissions.edit', compact('permission'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Permission  $permission
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Permission $permission)
    {
        if (!$request->user()->can('update', $permission)) {
            abort(401);
        }

        $this->validator($request->all())->validate();
        try {
            $permission->fill([
                'name' => request('name'),
                'description' => request('description'),
            ]);

            $permission->save();
        } catch (\Exception $err) {
            return back()->with('notify', $this->notifArray('DB', 'error', $err->getMessage(), true));
        }
        return redirect()->route('permissions.edit', $permission)
            ->with('notify', $this->notifArray('DB', 'success', __('Permesso aggiornato con successo')));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Permission  $permission
     * @return \Illuminate\Http\Response
     */
    public function destroy(Permission $permission)
    {
        if (!auth()->user()->can('delete', $permission)) {
            abort(401);
        }
// TODO : Gestire detach
        try {
            $permission->delete();
        } catch (\Exception $err) {
            return back()->with('notify', $this->notifArray('DB', 'error', $err->getMessage(), true));
        }
        return redirect()->route('permissions.index', $permission)
            ->with('notify', $this->notifArray('DB', 'success', __('Permesso eliminato con successo')));
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    public function validator(array $data)
    {
        return Validator::make($data, [
            'name'              => 'required|string|max:255',
            'description'       => 'nullable|string|max:255',
        ]);
    }

}
