<?php

namespace Sartoric\ModularCms\Models;

use Illuminate\Database\Eloquent\Model as Eloquent;
use \Illuminate\Support\Facades\Schema;

class McmsModel extends Eloquent
{
    protected $guarded=[];

    protected static function boot()
    {
        parent::boot();

        //
        static::creating(function ($model) {
            if ($model->isDirty() && !empty(auth()->user()) && Schema::hasColumn($model->getTable(), 'created_by')) {
                $model->created_by = auth()->user()->id;
            }
        });

        static::saving(function ($model) {
            if ($model->isDirty() && !empty(auth()->user()) && Schema::hasColumn($model->getTable(), 'updated_by')) {
                $model->updated_by = auth()->user()->id;
            }
        });

    }

}
