<?php

namespace Sartoric\ModularCms\Models;

use Illuminate\Support\Facades\Route;
//use Illuminate\Contracts\Routing\Registrar as Route;

class Menuitem extends McmsModel
{
    protected $table = "sys_menuitems";

    public $timestamps = false;

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'sys_menuitem_role');
    }

    /**
     *
     * Return the collection of submenu that belongs to the current menu instance
     *
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function submenu()
    {
        return Menuitem::where('parent', $this->id)->get();
    }

    /**
     * Verify if the current main menu is active
     *
     * @return bool
     */
    public function isActiveMenu()
    {
        if ($dotpos = strpos(Route::currentRouteName(), '.')) {
            $lastlevel = substr(Route::currentRouteName(), 0, $dotpos);
        } else {
            $lastlevel = Route::currentRouteName();
        }
        $appAdmin = Setting::appSetting('app-admin');
        if (!empty($appAdmin)) {
            $lastlevel = $appAdmin.'/'.$lastlevel;
        }
        if (($this->submenu()->contains('link', $lastlevel)) || ($this->link == $lastlevel)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Get the relationships for the entity.
     *
     * @return array
     */
    public function getQueueableRelations()
    {
        // TODO: Implement getQueueableRelations() method.
    }

    public function getLinkAttribute($value)
    {
        $appAdmin = Setting::appSetting('app-admin');
        if (!empty($appAdmin) &&
            substr($value, 0, strlen($appAdmin)) !== $appAdmin) {
            return $appAdmin.'/'.$value;
        }
        return $value;
    }
}
