<?php

namespace Sartoric\ModularCms\Models;

use Illuminate\Support\Facades\Schema;

class Setting extends McmsModel
{
    public $timestamps = false;

    protected $table = 'sys_settings';

    public static function appsettings()
    {
        return Setting::where('user_id', 0)->get();
    }

    public static function appSetting($setId)
    {
        $appsetting = null;
        // check if table exists to avois issues with fresh installation (web routes won't work)
        if (Schema::hasTable('sys_settings')) {
            $appsetting = Setting::where('user_id', 0)
                ->where('setting', $setId)
                ->first();
        }
        if (empty($appsetting)) {
            return config('app.'.$setId, '');
        } else {
            return $appsetting->value;
        }
    }

}
