<?php

namespace Sartoric\ModularCms\Policies;

use Sartoric\ModularCms\Models\User;
use Sartoric\ModularCms\Models\Role;
use Illuminate\Auth\Access\HandlesAuthorization;

class RolePolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    public function before(User $user)
    {
        if ($user->isSuperAdmin()) {
            return true;
        }
    }

    public function update(User $user, Role $role_model)
    {
        if (!$user->hasPermission('role-update') && !$role_model->system) {
            return false;
        }
        return true;
    }

    public function create(User $user)
    {
        if (!$user->hasPermission('role-create')) {
            return false;
        }
        return true;
    }

    public function delete(User $user, Role $role)
    {
        return false;
    }
}
