<?php

namespace Sartoric\ModularCms\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class McmsAuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        'Sartoric\ModularCms\Models\Model'       => 'Sartoric\ModularCms\Policies\ModelPolicy',
        'Sartoric\ModularCms\Models\Role'        => 'Sartoric\ModularCms\Policies\RolePolicy',
        'Sartoric\ModularCms\Models\Menuitem'    => 'Sartoric\ModularCms\Policies\MenuitemPolicy',
        'Sartoric\ModularCms\Models\User'        => 'Sartoric\ModularCms\Policies\UserPolicy',
        'Sartoric\ModularCms\Models\Permission'  => 'Sartoric\ModularCms\Policies\PermissionPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();
        config(['auth.providers.users.model' => \Sartoric\ModularCms\Models\User::class]);
    }
}
