<?php

namespace Sartoric\ModularCms\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PermissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('sys_permissions')->insert(
            array(
                [
                    "id" => 1,
                    "name" => "user-update",
                    "description" => "Aggiornamento utente",
                    'system' => true
                ],
                [
                    "id" => 2,
                    "name" => "user-create",
                    "description" => "Creazione utenti non admin",
                    'system' => true
                ],
                [
                    "id" => 3,
                    "name" => "user-sa-update",
                    "description" => "Aggiornamento superadmin",
                    'system' => true
                ],
                [
                    "id" => 4,
                    "name" => "user-sa-create",
                    "description" => "Creazione di un superadmin",
                    'system' => true
                ],
                [
                    "id" => 5,
                    "name" => "user-delete",
                    "description" => "Cancellazione di un utente",
                    'system' => true
                ],
                [
                    "id" => 6,
                    "name" => "user-pwd-update",
                    "description" => "L'utente può cambiare la sua password",
                    'system' => false
                ],
                [
                    "id" => 7,
                    "name" => "user-profile-view",
                    "description" => "L'utente può vedere la pagina di profilo",
                    'system' => true
                ],
                [
                    "id" => 8,
                    "name" => "user-profile-edit",
                    "description" => "L'utente può modificare il suo profilo",
                    'system' => true
                ],
                [
                    "id" => 9,
                    "name" => "role-update",
                    "description" => "L'utente può modificare i ruoli",
                    'system' => false
                ],
                [
                    "id" => 10,
                    "name" => "role-create",
                    "description" => "L'utente può creare i ruoli",
                    'system' => false
                ],
            )
        );
    }
}
