<?php
namespace Sartoric\ModularCms\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class RolesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        DB::table('sys_roles')->insert(
            array(
                [
                    'id'          => 1,
                    'name'        => 'Superadmin',
                    'description' => 'Amministratore',
                    'system'      => true
                ],
                [
                    'id'          => 2,
                    'name'        => 'Admin',
                    'description' => 'Amministratore dell\'applicazione',
                    'system'      => true
                ],
                [
                    'id'          => 3,
                    'name'        => 'User',
                    'description' => 'Utente dell\'applicazione',
                    'system'      => false
                ],

            )
        );

        DB::table('sys_role_user')->insert(
            array(
                [
                    'user_id'        => 1,
                    'role_id'        => 1
                ],
            )
        );

        DB::table('sys_menuitem_role')->insert(
            array(
                [
                    'menuitem_id'    => 1,
                    'role_id'        => 3
                ],
                [
                    'menuitem_id'    => 2,
                    'role_id'        => 3
                ],
                [
                    'menuitem_id'    => 3,
                    'role_id'        => 2
                ],
                [
                    'menuitem_id'    => 4,
                    'role_id'        => 2
                ],
                [
                    'menuitem_id'    => 5,
                    'role_id'        => 1
                ]
            )
        );

        DB::table('sys_role_permission')->insert(
            array(
                [
                    'permission_id'    => 3,
                    'role_id'        => 1
                ],
                [
                    'permission_id'    => 4,
                    'role_id'        => 1
                ],
                [
                    'permission_id'    => 1,
                    'role_id'        => 2
                ],
                [
                    'permission_id'    => 2,
                    'role_id'        => 2
                ],
                [
                    'permission_id'    => 5,
                    'role_id'        => 2
                ],
                [
                    'permission_id'    => 5,
                    'role_id'        => 6
                ],
                [
                    'permission_id'    => 6,
                    'role_id'        => 3
                ],
            )
        );
    }
}
