@extends('sartoric/modularcms::layouts.main')
@include('sartoric/modularcms::layouts.partials.body-tag')

@section('css-page')
    <link href="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-select/css/bootstrap-select.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN SAMPLE FORM PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-{{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}">
                        <i class="icon-pencil font-{{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}"></i>
                        <span class="caption-subject bold uppercase"> {{ __('Modifica menu') }}</span>
                    </div>
                </div>
                <div class="portlet-body form">
                    <form role="form" class="login-form form-horizontal" method="post" action="{{ action('\Sartoric\ModularCms\Controllers\Layouts\MenuitemController@update',['menuitem'=>$menuitem->id]) }}">
                        {{ csrf_field() }}
                        {{ method_field('PUT') }}

                        @include('sartoric/modularcms::layouts.menuitem.partials.formfields')

                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-2 col-md-10">
                                    <button type="submit" class="btn {{ Sartoric\ModularCms\Models\Setting::appsetting('app-main-color') }}">{{ __('Modifica') }}</button>
                                </div>
                            </div>
                        </div>

                    </form>
                @include('sartoric/modularcms::layouts.partials.errors')
                </div>
            </div>
            <!-- END SAMPLE FORM PORTLET-->
        </div>
    </div>
@endsection

@section('script-page')
    <script src="{{ McmsHelper::mcmsAsset('assets/pages/scripts/components-bootstrap-select.min.js') }}" type="text/javascript"></script>
@endsection

@section('plugin-page')
    <script src="{{ McmsHelper::mcmsAsset('assets/global/plugins/bootstrap-select/js/bootstrap-select.min.js') }}" type="text/javascript"></script>
@endsection
