
<div class="form-body">

    <div class="form-group form-md-line-input {{ $errors->has('name')?' has-error ':'' }}">
        <label class="col-md-2 control-label" for="name">{{ __('Ruolo') }}</label>
        <div class="col-md-9">
            <input type="text" class="form-control" id="name" name="name" value="{{ $role->name }}">
            <div class="form-control-focus"> </div>
            <span class="help-block">{{ __('Nome ruolo') }}</span>
        </div>
    </div>

    <div class="form-group form-md-line-input {{ $errors->has('description')?' has-error ':'' }}">
        <label class="col-md-2 control-label" for="label">{{ __('Descrizione') }}</label>
        <div class="col-md-9">
            <input type="text" class="form-control" id="description" name="description" value="{{ $role->description }}">
            <div class="form-control-focus"> </div>
            <span class="help-block">{{ __('Descrizione ruolo') }}</span>
        </div>
    </div>
    {{--MENU ATTIVI--}}
    <div class="form-group form-md-line-input">
        <label for="menulist" class="control-label col-md-2">{{ __('Menu') }} <span class="required">* </span></label>
        <div class="col-md-9 input-icon right">
            <select multiple id="menulist" name="menulist[]" class="form-control select2-multiple-nosearch" data-placeholder="{{ __('Selezionare un menu') }}" >
                @foreach($menuitems as $menuitem)
                    <option value="{{ $menuitem->id }}" {{ $rolemenus->contains($menuitem->id)?'selected':'' }} >{{ ucwords($menuitem->label) }}</option>
                @endforeach
            </select>
            <i class="fa fa-caret-down"></i>
        </div>
    </div>

    {{--PERMESSI--}}
    <div class="form-group form-md-line-input">
        <label for="permlist" class="control-label col-md-2">{{ __('Permessi') }} <span class="required">* </span></label>
        <div class="col-md-9 input-icon right">
            <select multiple id="permlist" name="permlist[]" class="form-control select2-multiple-nosearch" data-placeholder="{{ __('Selezionare un permesso') }}" >
                @foreach($permitems as $permitem)
                    <option value="{{ $permitem->id }}" {{ $rolepermissions->contains($permitem->id)?'selected':'' }} >{{ ucwords($permitem->description) }}</option>
                @endforeach
            </select>
            <i class="fa fa-caret-down"></i>
        </div>
    </div>

    <!--SYSTEM-->
    @if(auth()->user()->isSuperadmin())
    <div class="form-group form-md-line-input">
        <label for="system" class="control-label col-md-2">{{ __('System') }} </label>
        <div class="col-md-4">
            <div class="md-checkbox-list">
                <div class="md-checkbox">
                    <input type="checkbox" id="system" name="system" {{ $role->system?'checked':'' }} class="md-check">
                    <label for="system">
                        <span class="inc"></span>
                        <span class="check"></span>
                        <span class="box"></span>
                    </label>
                </div>
            </div>
        </div>
    </div>
    @endif

</div>
